// priority: 100

Platform.mods.kubejs.name = 'CapyLand'
const Capy = {};

// Allow to deny a tool specific tags
Capy.setIncorrectTagForTool = (tool, tags) => {
	return event => event.modify(tool, item => item.setTier(tier => tier.setIncorrectBlocksForDropsTag(tags)));
}

// Overwrite a tool's tier
Capy.setToolTier = (event, tool, tier) => {
	return event.modify(tool, item => item.setTier(t => {
		t.setUses(tool.includes('paxel') ? tier.durability * 2 : tier.durability);
		t.setAttackDamageBonus(tool.includes('paxel') ? -5 : tier.damage);
		t.setSpeed(tier.speed);
		t.setEnchantmentValue(tier.enchantment);
		t.setIncorrectBlocksForDropsTag(tier.incorrect);
		t.setRepairIngredient(tier.repair);
	}));
}