// Recipes you unlock after crafting your first flint tool
Capy.addRestrictionForList('flint', [
	'minecraft:campfire',
	'minecraft:furnace'
]);

Capy.addRestrictionForList('kiln', [
		'immersiveengineering:alloybrick',
		'immersiveengineering:slab_alloybrick',
		'immersiveengineering:alloy_smelter'
	]
);

// Recipes you unlock at bronze era
Capy.addRestrictionForList('bronze', [
	'magistuarmory:bronze_stylet',
	'magistuarmory:bronze_shortsword',
	'magistuarmory:bronze_katzbalger',
	'magistuarmory:bronze_pike',
	'magistuarmory:bronze_ranseur',
	'magistuarmory:bronze_ahlspiess',
	'magistuarmory:bronze_chivalrylance',
	'magistuarmory:bronze_bastardsword',
	'magistuarmory:bronze_estoc',
	'magistuarmory:bronze_claymore',
	'magistuarmory:bronze_zweihander',
	'magistuarmory:bronze_flamebladedsword',
	'magistuarmory:bronze_lochaberaxe',
	'magistuarmory:bronze_concavehalberd',
	'magistuarmory:bronze_heavymace',
	'magistuarmory:bronze_heavywarhammer',
	'magistuarmory:bronze_lucernhammer',
	'magistuarmory:bronze_morgenstern',
	'magistuarmory:bronze_chainmorgenstern',
	'magistuarmory:bronze_guisarme',
	'magistuarmory:bronze_heatershield',
	'magistuarmory:bronze_target',
	'magistuarmory:bronze_buckler',
	'magistuarmory:bronze_rondache',
	'magistuarmory:bronze_tartsche',
	'magistuarmory:bronze_ellipticalshield',
	'magistuarmory:bronze_roundshield',
	'magistuarmory:bronze_pavese',
	'magistuarmory:bronze_kiteshield',

	'mekanism:dust_bronze',
	'mekanism:ingot_bronze',
	'mekanism:nugget_bronze',
	'mekanism:block_bronze',

	'mekanismtools:bronze_pickaxe',
	'mekanismtools:bronze_axe',
	'mekanismtools:bronze_shovel',
	'mekanismtools:bronze_hoe',
	'mekanismtools:bronze_sword',
	'mekanismtools:bronze_paxel',
	'mekanismtools:bronze_helmet',
	'mekanismtools:bronze_chestplate',
	'mekanismtools:bronze_leggings',
	'mekanismtools:bronze_boots',

	'sophisticatedbackpacks:copper_backpack',
	'sophisticatedstorage:copper_barrel',
	'sophisticatedstorage:copper_chest',
	'sophisticatedstorage:limited_copper_barrel_1',
	'sophisticatedstorage:limited_copper_barrel_2',
	'sophisticatedstorage:limited_copper_barrel_3',
	'sophisticatedstorage:limited_copper_barrel_4',
]);
AStages.addRestrictionForMod('astages/mod/create_deco', 'bronze', 'createdeco')
       .setCanBeStoredInInventory(true)
       .setCanBeStoredInContainers(true)
	   .setCanPickedUp(true)
       .associateLootRestriction();
AStages.addRestrictionForMod('astages/mod/storagedelight', 'bronze', 'storagedelight')
       .setCanBeStoredInInventory(true)
       .setCanBeStoredInContainers(true)
	   .setCanPickedUp(true)
       .associateLootRestriction();

ServerEvents.recipes(event => {
	event.forEachRecipe({ input: "mekanism:ingot_bronze", type: 'minecraft:crafting_shaped' }, recipe => {
		AStages.addRestrictionForRecipe(`astages/minecraft/bronze/${ recipe.getId().replace(':', '_') }`, 'bronze', 'crafting', recipe.getId());
	});
});


/*******************************************
 * Recipes you unlock in Iron era
 *******************************************/
Capy.addRestrictionForList('iron', [
	'minecraft:blast_furnace',
	'minecraft:iron_ingot',
	'minecraft:iron_nugget',
	'minecraft:iron_pickaxe',
	'minecraft:iron_axe',
	'minecraft:iron_sword',
	'minecraft:iron_hoe',
	'minecraft:iron_shovel',
	'minecraft:iron_helmet',
	'minecraft:iron_chestplate',
	'minecraft:iron_leggings',
	'minecraft:iron_boots',
	'minecraft:iron_bars',
	'minecraft:iron_trapdoor',

	// Sewing kit
	'legendarysurvivaloverhaul:sewing_table',

	// Fluid stuff
	'mekanism:basic_fluid_tank',
	'mekanism:advanced_fluid_tank',
	'mekanism:elite_fluid_tank',
	'mekanism:ultimate_fluid_tank',
	'mekanism:creative_fluid_tank',
	'immersiveengineering:fluid_pump',
	'immersiveengineering:fluid_placer',
	'immersiveengineering:fluid_pipe',
	'create:fluid_pipe',
	'immersiveengineering:tank',

	// Coke Oven stuff
	'immersiveengineering:coal_coke',
	'immersiveengineering:dust_coke',
	'immersiveengineering:cokebrick',
	'immersiveengineering:coke',
	'immersiveengineering:slab_cokebrick',
	'immersiveengineering:slab_coke',
	'immersiveengineering:coke_oven',

	'supplementaries:iron_gate',

	'farmersdelight:iron_knife',

	'mekanismtools:iron_paxel',

	'minecolonies:assistanthammer_iron',
	'minecolonies:iron_scimitar',

	'magistuarmory:iron_stylet',
	'magistuarmory:iron_heatershield',
	'magistuarmory:iron_target',
	'magistuarmory:iron_buckler',
	'magistuarmory:iron_rondache',
	'magistuarmory:iron_tartsche',
	'magistuarmory:iron_ellipticalshield',
	'magistuarmory:iron_roundshield',
	'magistuarmory:iron_pavese',
	'magistuarmory:iron_kiteshield',
	'magistuarmory:iron_shortsword',
	'magistuarmory:iron_katzbalger',
	'magistuarmory:iron_pike',
	'magistuarmory:iron_ranseur',
	'magistuarmory:iron_ahlspiess',
	'magistuarmory:iron_chivalrylance',
	'magistuarmory:iron_bastardsword',
	'magistuarmory:iron_estoc',
	'magistuarmory:iron_claymore',
	'magistuarmory:iron_zweihander',
	'magistuarmory:iron_flamebladedsword',
	'magistuarmory:iron_lochaberaxe',
	'magistuarmory:iron_concavehalberd',
	'magistuarmory:iron_heavymace',
	'magistuarmory:iron_heavywarhammer',
	'magistuarmory:iron_lucernhammer',
	'magistuarmory:iron_morgenstern',
	'magistuarmory:iron_chainmorgenstern',
	'magistuarmory:iron_guisarme',

	'immersiveengineering:plate_iron',
	'immersiveengineering:stick_iron',
	'immersiveengineering:drillhead_iron',
	'immersiveengineering:component_iron',
	'immersiveengineering:sheetmetal_iron',
	'immersiveengineering:slab_sheetmetal_iron',
	'immersiveengineering:chute_iron',
	'immersiveengineering:wirecutter',
	'immersiveengineering:screwdriver',

	'handcrafted:hammer',
	'mcwroofs:roofing_hammer',

	'sophisticatedbackpacks:iron_backpack',
	'sophisticatedstorage:iron_barrel',
	'sophisticatedstorage:limited_iron_barrel_1',
	'sophisticatedstorage:limited_iron_barrel_2',
	'sophisticatedstorage:limited_iron_barrel_3',
	'sophisticatedstorage:limited_iron_barrel_4',
	'sophisticatedstorage:iron_chest',
	'sophisticatedstorage:iron_shulker_box',

	// Silver
	'magistuarmory:silver_stylet',
	'magistuarmory:silver_shortsword',
	'magistuarmory:silver_katzbalger',
	'magistuarmory:silver_pike',
	'magistuarmory:silver_ranseur',
	'magistuarmory:silver_ahlspiess',
	'magistuarmory:silver_chivalrylance',
	'magistuarmory:silver_bastardsword',
	'magistuarmory:silver_estoc',
	'magistuarmory:silver_claymore',
	'magistuarmory:silver_zweihander',
	'magistuarmory:silver_flamebladedsword',
	'magistuarmory:silver_lochaberaxe',
	'magistuarmory:silver_concavehalberd',
	'magistuarmory:silver_heavymace',
	'magistuarmory:silver_heavywarhammer',
	'magistuarmory:silver_lucernhammer',
	'magistuarmory:silver_morgenstern',
	'magistuarmory:silver_chainmorgenstern',
	'magistuarmory:silver_guisarme',
	'magistuarmory:silver_heatershield',
	'magistuarmory:silver_target',
	'magistuarmory:silver_buckler',
	'magistuarmory:silver_rondache',
	'magistuarmory:silver_tartsche',
	'magistuarmory:silver_ellipticalshield',
	'magistuarmory:silver_roundshield',
	'magistuarmory:silver_pavese',
	'magistuarmory:silver_kiteshield',

	'magistuarmoryaddon:silver_necklace_decoration',
	'magistuarmoryaddon:silver_cross_necklace_decoration',

	'immersiveengineering:ingot_silver',
	'immersiveengineering:nugget_silver',
	'immersiveengineering:plate_silver',
	'immersiveengineering:dust_silver',
	'immersiveengineering:sheetmetal_silver',
	'immersiveengineering:slab_sheetmetal_silver',
	'immersiveengineering:raw_block_silver',
	'immersiveengineering:storage_silver',
	'immersiveengineering:slab_storage_silver'
]);
AStages.addRestrictionForMod('astages/mod/astikor', 'iron', 'astikorcartsredux')
	.setCanBeStoredInInventory(true)
	.setCanBeStoredInContainers(true)
	.setCanPickedUp(true)
	.associateLootRestriction();
AStages.addRestrictionForMod('astages/mod/workshop', 'iron', 'workshop_for_handsome_adventurer')
	.setCanBeStoredInInventory(true)
	.setCanBeStoredInContainers(true)
	.setCanPickedUp(true)
	.associateLootRestriction();

ServerEvents.recipes(event => {
	event.forEachRecipe({ input: "minecraft:iron_ingot", type: 'minecraft:crafting_shaped' }, recipe => {
		AStages.addRestrictionForRecipe(`astages/minecraft/iron/${ recipe.getId().replace(':', '_') }`, 'iron', 'crafting', recipe.getId());
	});

	event.forEachRecipe({ input: "minecraft:redstone", type: 'minecraft:crafting_shaped' }, recipe => {
		AStages.addRestrictionForRecipe(`astages/minecraft/redstone/${ recipe.getId().replace(':', '_') }`, 'iron', 'crafting', recipe.getId());
	});
});

/*******************************************
 * Recipes you unlock in Feudal era
 *******************************************/
Capy.addRestrictionForList('feudal', [
	// Gold stuff
	'mekanismtools:gold_paxel',

	'supplementaries:gold_bars',
	'supplementaries:gold_gate',
	'minecraft:gold_block',
	'supplementaries:gold_door',
	'supplementaries:gold_trapdoor',
	'minecraft:golden_shovel',
	'minecraft:golden_pickaxe',
	'minecraft:golden_axe',
	'minecraft:golden_hoe',
	'minecraft:golden_sword',
	'minecraft:golden_helmet',
	'minecraft:golden_chestplate',
	'minecraft:golden_leggings',
	'minecraft:golden_boots',
	'minecraft:golden_horse_armor',
	'minecraft:gold_nugget',
	'minecraft:gold_ingot',
	'magistuarmory:gilding_template',
	'magistuarmoryaddon:fully_gilding_template',
	'farmersdelight:golden_knife',
	'sophisticatedstorage:gold_barrel',
	'sophisticatedstorage:limited_gold_barrel_1',
	'sophisticatedstorage:limited_gold_barrel_2',
	'sophisticatedstorage:limited_gold_barrel_3',
	'sophisticatedstorage:limited_gold_barrel_4',
	'sophisticatedstorage:gold_chest',
	'sophisticatedstorage:gold_shulker_box',
	'minecolonies:assistanthammer_gold',
	'createaddition:electrum_amulet',
	'createaddition:gold_wire',
	'createaddition:gold_rod',
	'tfmg:golden_turbo',

	'immersiveengineering:plate_gold',
	'immersiveengineering:sheetmetal_gold',
	'immersiveengineering:slab_sheetmetal_gold',

	// Steel stuff
	'mekanismtools:steel_paxel',

	'mekanism:dust_steel',
	'mekanism:ingot_steel',
	'mekanism:nugget_steel',
	'mekanism:block_steel',
	'mekanism:steel_casing',

	'immersiveengineering:stick_steel',
	'immersiveengineering:component_steel',
	'immersiveengineering:wire_steel',
	'immersiveengineering:plate_steel',
	'immersiveengineering:pickaxe_steel',
	'immersiveengineering:shovel_steel',
	'immersiveengineering:axe_steel',
	'immersiveengineering:hoe_steel',
	'immersiveengineering:sword_steel',
	'immersiveengineering:drillhead_steel',
	'immersiveengineering:armor_steel_helmet',
	'immersiveengineering:armor_steel_chestplate',
	'immersiveengineering:armor_steel_leggings',
	'immersiveengineering:armor_steel_boots',
	'immersiveengineering:steel_fence',
	'immersiveengineering:steel_fence_gate',
	'immersiveengineering:steel_wallmount',
	'immersiveengineering:steel_post',
	'immersiveengineering:steel_slope',
	'immersiveengineering:steel_window',
	'immersiveengineering:steel_catwalk',
	'immersiveengineering:steel_catwalk_stairs',
	'immersiveengineering:steel_door',
	'immersiveengineering:steel_trapdoor',
	'immersiveengineering:sheetmetal_steel',
	'immersiveengineering:slab_sheetmetal_steel',
	'immersiveengineering:slab_storage_steel',
	'immersiveengineering:metal_ladder_steel',
	'immersiveengineering:steel_scaffolding_standard',
	'immersiveengineering:slab_steel_scaffolding_standard',
	'immersiveengineering:stairs_steel_scaffolding_standard',
	'immersiveengineering:steel_scaffolding_grate_top',
	'immersiveengineering:slab_steel_scaffolding_grate_top',
	'immersiveengineering:stairs_steel_scaffolding_grate_top',
	'immersiveengineering:steel_scaffolding_wooden_top',
	'immersiveengineering:slab_steel_scaffolding_wooden_top',
	'immersiveengineering:stairs_steel_scaffolding_wooden_top',
	'immersiveengineering:chute_steel',
	'immersiveengineering:steel_sign',
	'immersiveengineering:steel_hanging_sign',

	'pneumaticcraft:omnidirectional_hopper',
]);

AStages.addRestrictionForMod('astages/mod/epic_knight', 'feudal', 'magistuarmory')
	.setCanBeStoredInInventory(true)
	.setCanBeStoredInContainers(true)
	.setCanPickedUp(true)
	.ignoreItems(
		// Leather materials
		'magistuarmory:leather_strip',
		'magistuarmory:hilt',
		'magistuarmory:pole',
		'magistuarmory:woolen_fabric',
		'magistuarmory:chainmail_boots',
		'magistuarmory:pantyhose',
		'magistuarmory:gambeson_boots',
		'magistuarmory:coif',
		'magistuarmory:gambeson_chestplate',
		'magistuarmory:cuirassier_leggings',
		'magistuarmory:cuirassier_boots',
		'magistuarmory:rusted_bastardsword',
		'magistuarmory:rusted_heavymace',
		'magistuarmory:corruptedroundshield',
		'magistuarmory:rustedbarbute',
		'magistuarmory:rustedhalfarmor_chestplate',
		'magistuarmory:rustedgreathelm',
		'magistuarmory:rustedcrusader_chestplate',
		'magistuarmory:rustedcrusader_boots',
		'magistuarmory:rustednorman_helmet',
		'magistuarmory:rustedchainmail_helmet',
		'magistuarmory:rustedchainmail_chestplate',
		'magistuarmory:rustedchainmail_leggings',
		'magistuarmory:rustedchainmail_boots',
		'magistuarmory:rustedkettlehat',
		'magistuarmory:torse_and_mantle_decoration',
		'magistuarmory:gazelle_horns_decoration',
		'magistuarmory:duck_decoration',
		'magistuarmory:horse_decoration',
		'magistuarmory:flowercrown_decoration',

		// Wood
		'magistuarmory:wood_heatershield',
		'magistuarmory:wood_target',
		'magistuarmory:wood_buckler',
		'magistuarmory:wood_rondache',
		'magistuarmory:wood_tartsche',
		'magistuarmory:wood_ellipticalshield',
		'magistuarmory:wood_roundshield',
		'magistuarmory:wood_pavese',
		'magistuarmory:wood_kiteshield',

		// Stone
		'magistuarmory:stone_stylet',
		'magistuarmory:stone_shortsword',
		'magistuarmory:stone_katzbalger',
		'magistuarmory:stone_pike',
		'magistuarmory:stone_ranseur',
		'magistuarmory:stone_ahlspiess',
		'magistuarmory:stone_chivalrylance',
		'magistuarmory:stone_bastardsword',
		'magistuarmory:stone_estoc',
		'magistuarmory:stone_claymore',
		'magistuarmory:stone_zweihander',
		'magistuarmory:stone_flamebladedsword',
		'magistuarmory:stone_lochaberaxe',
		'magistuarmory:stone_concavehalberd',
		'magistuarmory:stone_heavymace',
		'magistuarmory:stone_heavywarhammer',
		'magistuarmory:stone_lucernhammer',
		'magistuarmory:stone_morgenstern',
		'magistuarmory:stone_chainmorgenstern',
		'magistuarmory:stone_guisarme',
		'magistuarmory:stone_buckler',
		'magistuarmory:stone_heatershield',
		'magistuarmory:stone_target',
		'magistuarmory:stone_rondache',
		'magistuarmory:stone_tartsche',
		'magistuarmory:stone_ellipticalshield',
		'magistuarmory:stone_roundshield',
		'magistuarmory:stone_pavese',
		'magistuarmory:stone_kiteshield',

		// Tin
		'magistuarmory:tin_stylet',
		'magistuarmory:tin_shortsword',
		'magistuarmory:tin_katzbalger',
		'magistuarmory:tin_pike',
		'magistuarmory:tin_ranseur',
		'magistuarmory:tin_ahlspiess',
		'magistuarmory:tin_chivalrylance',
		'magistuarmory:tin_bastardsword',
		'magistuarmory:tin_estoc',
		'magistuarmory:tin_claymore',
		'magistuarmory:tin_zweihander',
		'magistuarmory:tin_flamebladedsword',
		'magistuarmory:tin_lochaberaxe',
		'magistuarmory:tin_concavehalberd',
		'magistuarmory:tin_heavymace',
		'magistuarmory:tin_heavywarhammer',
		'magistuarmory:tin_lucernhammer',
		'magistuarmory:tin_morgenstern',
		'magistuarmory:tin_guisarme',
		'magistuarmory:tin_chainmorgenstern',
		'magistuarmory:tin_heatershield',
		'magistuarmory:tin_target',
		'magistuarmory:tin_buckler',
		'magistuarmory:tin_rondache',
		'magistuarmory:tin_tartsche',
		'magistuarmory:tin_ellipticalshield',
		'magistuarmory:tin_roundshield',
		'magistuarmory:tin_pavese',
		'magistuarmory:tin_kiteshield',

		// Bronze
		'magistuarmory:bronze_stylet',
		'magistuarmory:bronze_shortsword',
		'magistuarmory:bronze_katzbalger',
		'magistuarmory:bronze_pike',
		'magistuarmory:bronze_ranseur',
		'magistuarmory:bronze_ahlspiess',
		'magistuarmory:bronze_chivalrylance',
		'magistuarmory:bronze_bastardsword',
		'magistuarmory:bronze_estoc',
		'magistuarmory:bronze_claymore',
		'magistuarmory:bronze_zweihander',
		'magistuarmory:bronze_flamebladedsword',
		'magistuarmory:bronze_lochaberaxe',
		'magistuarmory:bronze_concavehalberd',
		'magistuarmory:bronze_heavymace',
		'magistuarmory:bronze_heavywarhammer',
		'magistuarmory:bronze_lucernhammer',
		'magistuarmory:bronze_morgenstern',
		'magistuarmory:bronze_chainmorgenstern',
		'magistuarmory:bronze_guisarme',
		'magistuarmory:bronze_heatershield',
		'magistuarmory:bronze_target',
		'magistuarmory:bronze_buckler',
		'magistuarmory:bronze_rondache',
		'magistuarmory:bronze_tartsche',
		'magistuarmory:bronze_ellipticalshield',
		'magistuarmory:bronze_roundshield',
		'magistuarmory:bronze_pavese',
		'magistuarmory:bronze_kiteshield',

		// Iron
		'magistuarmory:iron_stylet',
		'magistuarmory:iron_heatershield',
		'magistuarmory:iron_target',
		'magistuarmory:iron_buckler',
		'magistuarmory:iron_rondache',
		'magistuarmory:iron_tartsche',
		'magistuarmory:iron_ellipticalshield',
		'magistuarmory:iron_roundshield',
		'magistuarmory:iron_pavese',
		'magistuarmory:iron_kiteshield',
		'magistuarmory:iron_shortsword',
		'magistuarmory:iron_katzbalger',
		'magistuarmory:iron_pike',
		'magistuarmory:iron_ranseur',
		'magistuarmory:iron_ahlspiess',
		'magistuarmory:iron_chivalrylance',
		'magistuarmory:iron_bastardsword',
		'magistuarmory:iron_estoc',
		'magistuarmory:iron_claymore',
		'magistuarmory:iron_zweihander',
		'magistuarmory:iron_flamebladedsword',
		'magistuarmory:iron_lochaberaxe',
		'magistuarmory:iron_concavehalberd',
		'magistuarmory:iron_heavymace',
		'magistuarmory:iron_heavywarhammer',
		'magistuarmory:iron_lucernhammer',
		'magistuarmory:iron_morgenstern',
		'magistuarmory:iron_chainmorgenstern',
		'magistuarmory:iron_guisarme',

		// Silver
		'magistuarmory:silver_stylet',
		'magistuarmory:silver_shortsword',
		'magistuarmory:silver_katzbalger',
		'magistuarmory:silver_pike',
		'magistuarmory:silver_ranseur',
		'magistuarmory:silver_ahlspiess',
		'magistuarmory:silver_chivalrylance',
		'magistuarmory:silver_bastardsword',
		'magistuarmory:silver_estoc',
		'magistuarmory:silver_claymore',
		'magistuarmory:silver_zweihander',
		'magistuarmory:silver_flamebladedsword',
		'magistuarmory:silver_lochaberaxe',
		'magistuarmory:silver_concavehalberd',
		'magistuarmory:silver_heavymace',
		'magistuarmory:silver_heavywarhammer',
		'magistuarmory:silver_lucernhammer',
		'magistuarmory:silver_morgenstern',
		'magistuarmory:silver_chainmorgenstern',
		'magistuarmory:silver_guisarme',
		'magistuarmory:silver_heatershield',
		'magistuarmory:silver_target',
		'magistuarmory:silver_buckler',
		'magistuarmory:silver_rondache',
		'magistuarmory:silver_tartsche',
		'magistuarmory:silver_ellipticalshield',
		'magistuarmory:silver_roundshield',
		'magistuarmory:silver_pavese',
		'magistuarmory:silver_kiteshield',
	)
	.associateLootRestriction();
AStages.addRestrictionForMod('astages/mod/epic_knight_addon', 'feudal', 'magistuarmoryaddon')
	.setCanBeStoredInInventory(true)
	.setCanBeStoredInContainers(true)
	.setCanPickedUp(true)
	.ignoreItems(
		// Leather
		'magistuarmoryaddon:orange_puff_and_slash_chestplate',
		'magistuarmoryaddon:orange_puff_and_slash_leggings',
		'magistuarmoryaddon:magenta_puff_and_slash_chestplate',
		'magistuarmoryaddon:magenta_puff_and_slash_leggings',
		'magistuarmoryaddon:light_blue_puff_and_slash_chestplate',
		'magistuarmoryaddon:light_blue_puff_and_slash_leggings',
		'magistuarmoryaddon:yellow_puff_and_slash_chestplate',
		'magistuarmoryaddon:yellow_puff_and_slash_leggings',
		'magistuarmoryaddon:lime_puff_and_slash_chestplate',
		'magistuarmoryaddon:lime_puff_and_slash_leggings',
		'magistuarmoryaddon:pink_puff_and_slash_chestplate',
		'magistuarmoryaddon:pink_puff_and_slash_leggings',
		'magistuarmoryaddon:gray_puff_and_slash_chestplate',
		'magistuarmoryaddon:gray_puff_and_slash_leggings',
		'magistuarmoryaddon:light_gray_puff_and_slash_chestplate',
		'magistuarmoryaddon:light_gray_puff_and_slash_leggings',
		'magistuarmoryaddon:cyan_puff_and_slash_chestplate',
		'magistuarmoryaddon:cyan_puff_and_slash_leggings',
		'magistuarmoryaddon:purple_puff_and_slash_chestplate',
		'magistuarmoryaddon:purple_puff_and_slash_leggings',
		'magistuarmoryaddon:blue_puff_and_slash_chestplate',
		'magistuarmoryaddon:blue_puff_and_slash_leggings',
		'magistuarmoryaddon:brown_puff_and_slash_chestplate',
		'magistuarmoryaddon:brown_puff_and_slash_leggings',
		'magistuarmoryaddon:green_puff_and_slash_chestplate',
		'magistuarmoryaddon:green_puff_and_slash_leggings',
		'magistuarmoryaddon:red_puff_and_slash_chestplate',
		'magistuarmoryaddon:red_puff_and_slash_leggings',
		'magistuarmoryaddon:black_puff_and_slash_chestplate',
		'magistuarmoryaddon:black_puff_and_slash_leggings',
		'magistuarmoryaddon:white_puff_and_slash_chestplate',
		'magistuarmoryaddon:white_puff_and_slash_leggings',
		'magistuarmoryaddon:puff_and_slash_boots',
		'magistuarmoryaddon:condottiero_cap',
		'magistuarmoryaddon:straw_hat',
		'magistuarmoryaddon:fancy_hat',
		'magistuarmoryaddon:tunic',
		'magistuarmoryaddon:tunic_boots',
		'magistuarmoryaddon:doublet',
		'magistuarmoryaddon:shoes',
		'magistuarmoryaddon:tilted_puff_and_slash_hat',
		'magistuarmoryaddon:landsknecht_orange_hat_decoration',
		'magistuarmoryaddon:landsknecht_magenta_hat_decoration',
		'magistuarmoryaddon:landsknecht_light_blue_hat_decoration',
		'magistuarmoryaddon:landsknecht_yellow_hat_decoration',
		'magistuarmoryaddon:landsknecht_lime_hat_decoration',
		'magistuarmoryaddon:landsknecht_pink_hat_decoration',
		'magistuarmoryaddon:landsknecht_gray_hat_decoration',
		'magistuarmoryaddon:landsknecht_light_gray_hat_decoration',
		'magistuarmoryaddon:landsknecht_cyan_hat_decoration',
		'magistuarmoryaddon:landsknecht_purple_hat_decoration',
		'magistuarmoryaddon:landsknecht_blue_hat_decoration',
		'magistuarmoryaddon:landsknecht_brown_hat_decoration',
		'magistuarmoryaddon:landsknecht_green_hat_decoration',
		'magistuarmoryaddon:landsknecht_red_hat_decoration',
		'magistuarmoryaddon:landsknecht_black_hat_decoration',
		'magistuarmoryaddon:landsknecht_white_hat_decoration',
		'magistuarmoryaddon:leather_gloves_decoration',
		'magistuarmoryaddon:medieval_cloak_decoration',
		'magistuarmoryaddon:puff_and_slash_robe_decoration',
		'magistuarmoryaddon:red_cross_medieval_cloak_decoration',
		'magistuarmoryaddon:white_cross_medieval_cloak_decoration',
		'magistuarmoryaddon:leather_gloves_decoration',
		'magistuarmoryaddon:medieval_cloak_decoration',
		'magistuarmoryaddon:puff_and_slash_robe_decoration',
		'magistuarmoryaddon:red_cross_medieval_cloak_decoration',
		'magistuarmoryaddon:white_cross_medieval_cloak_decoration',

		// Silver
		'magistuarmoryaddon:silver_necklace_decoration',
		'magistuarmoryaddon:silver_cross_necklace_decoration',

		// Zinc
		'create:zinc_nugget',
		'create:zinc_ingot',
	)
	.associateLootRestriction();
AStages.addRestrictionForMod('astages/mod/toms_storage', 'feudal', 'toms_storage')
	.setCanBeStoredInInventory(true)
	.setCanBeStoredInContainers(true)
	.setCanPickedUp(true)
	.associateLootRestriction();


ServerEvents.recipes(event => {
	event.forEachRecipe({ input: "minecraft:diamond", type: 'minecraft:crafting_shaped' }, recipe => {
		AStages.addRestrictionForRecipe(`astages/minecraft/diamond/${ recipe.getId().replace(':', '_') }`, 'feudal', 'crafting', recipe.getId());
	});

	event.forEachRecipe({ input: "minecraft:gold_ingot", type: 'minecraft:crafting_shaped' }, recipe => {
		AStages.addRestrictionForRecipe(`astages/minecraft/gold/${ recipe.getId().replace(':', '_') }`, 'feudal', 'crafting', recipe.getId());
	});

	event.forEachRecipe({ input: "oritech:steel_ingot", type: 'minecraft:crafting_shaped' }, recipe => {
		AStages.addRestrictionForRecipe(`astages/minecraft/steel/${ recipe.getId().replace(':', '_') }`, 'feudal', 'crafting', recipe.getId());
	});

	event.forEachRecipe({ input: "minecraft:obsidian", type: 'minecraft:crafting_shaped' }, recipe => {
		AStages.addRestrictionForRecipe(`astages/minecraft/obsidian/${ recipe.getId().replace(':', '_') }`, 'feudal', 'crafting', recipe.getId());
	});

	event.forEachRecipe({ input: "immersiveengineering:ingot_aluminum", type: 'minecraft:crafting_shaped' }, recipe => {
		AStages.addRestrictionForRecipe(`astages/minecraft/aluminum/${ recipe.getId().replace(':', '_') }`, 'feudal', 'crafting', recipe.getId());
	});
});


/*******************************************
 * Recipes you unlock in Steam era
 *******************************************/
Capy.addRestrictionForList('steam', [
	// Create has too many blocks lets just do specific create components
	'create:andesite_alloy',
	'create:copper_backtank',
	'create:netherite_backtank',
	'create:wrench',
	'create:linked_controller',
	'create:potato_cannon',
	'create:extendo_grip',
	'create:wand_of_symmetry',
	'create:handheld_worldshaper',
	'create:schematicannon',
	'create:schematic_table',
	'create:shaft',
	'create:cogwheel',
	'create:large_cogwheel',
	'create:gearbox',
	'create:vertical_gearbox',
	'create:clutch',
	'create:gearshift',
	'create:encased_chain_drive',
	'create:adjustable_chain_gearshift',
	'create:belt_connector',
	'create:chain_conveyor',
	'create:water_wheel',
	'create:large_water_wheel',
	'create:encased_fan',
	'create:nozzle',
	'create:turntable',
	'create:hand_crank',
	'create:cuckoo_clock',
	'create:millstone',
	'create:crushing_wheel',
	'create:mechanical_press',
	'create:mechanical_mixer',
	'create:basin',
	'create:empty_blaze_burner',
	'create:blaze_burner',
	'create:depot',
	'create:weighted_ejector',
	'create:chute',
	'create:smart_chute',
	'create:speedometer',
	'create:stressometer',
	'create:wooden_bracket',
	'create:metal_bracket',
	'create:mechanical_pump',
	'create:smart_fluid_pipe',
	'create:fluid_valve',
	'create:fluid_tank',
	'create:hose_pulley',
	'create:item_drain',
	'create:spout',
	'create:portable_fluid_interface',
	'create:steam_engine',
	'create:steam_whistle',
	'create:mechanical_piston',
	'create:sticky_mechanical_piston',
	'create:piston_extension_pole',
	'create:gantry_carriage',
	'create:gantry_shaft',
	'create:windmill_bearing',
	'create:clockwork_bearing',
	'create:mechanical_bearing',
	'create:rope_pulley',
	'create:elevator_pulley',
	'create:cart_assembler',
	'create:linear_chassis',
	'create:controller_rail',
	'create:secondary_linear_chassis',
	'create:radial_chassis',
	'create:sticker',
	'create:contraption_controls',
	'create:mechanical_drill',
	'create:mechanical_saw',
	'create:deployer',
	'create:portable_storage_interface',
	'create:redstone_contact',
	'create:mechanical_harvester',
	'create:mechanical_plough',
	'create:mechanical_roller',
	'create:sail_frame',
	'create:white_sail',
	'create:andesite_casing',
	'create:brass_casing',
	'create:copper_casing',
	'create:mechanical_crafter',
	'create:sequenced_gearshift',
	'create:flywheel',
	'create:rotation_speed_controller',
	'create:mechanical_arm',
	'create:track',
	'create:railway_casing',
	'create:schedule',
	'create:track_station',
	'create:track_signal',
	'create:track_observer',
	'create:controls',
	'create:andesite_funnel',
	'create:brass_funnel',
	'create:andesite_tunnel',
	'create:brass_tunnel',
	'create:content_observer',
	'create:stockpile_switch',
	'create:item_vault',
	'create:item_hatch',
	'create:packager',
	'create:repackager',
	'create:package_frogport',
	'create:stock_link',
	'create:stock_ticker',
	'create:redstone_requester',
	'create:factory_gauge',
	'create:display_link',
	'create:display_board',
	'create:nixie_tube',
	'create:analog_lever',
	'create:placard',
	'create:netherite_diving_helmet',
	'create:netherite_diving_boots',
	'create:andesite_scaffolding',
	'create:andesite_alloy_block',

	// Osmium stuff
	'mekanismtools:osmium_pickaxe',
	'mekanismtools:osmium_axe',
	'mekanismtools:osmium_shovel',
	'mekanismtools:osmium_hoe',
	'mekanismtools:osmium_sword',
	'mekanismtools:osmium_paxel',
	'mekanismtools:osmium_helmet',
	'mekanismtools:osmium_chestplate',
	'mekanismtools:osmium_leggings',
	'mekanismtools:osmium_boots',

	// Diamond stuff
	'mekanismtools:diamond_paxel',
	'sophisticatedbackpacks:diamond_backpack',
	'sophisticatedstorage:diamond_barrel',
	'sophisticatedstorage:limited_diamond_barrel_1',
	'sophisticatedstorage:limited_diamond_barrel_2',
	'sophisticatedstorage:limited_diamond_barrel_3',
	'sophisticatedstorage:limited_diamond_barrel_4',
	'sophisticatedstorage:diamond_chest',
	'sophisticatedstorage:diamond_shulker_box',

	// Netherite stuff
	'mekanismtools:netherite_paxel',
	'sophisticatedbackpacks:netherite_backpack',
	'sophisticatedstorage:netherite_barrel',
	'sophisticatedstorage:limited_netherite_barrel_1',
	'sophisticatedstorage:limited_netherite_barrel_2',
	'sophisticatedstorage:limited_netherite_barrel_3',
	'sophisticatedstorage:limited_netherite_barrel_4',
	'sophisticatedstorage:netherite_chest',
	'sophisticatedstorage:netherite_shulker_box',

]);
AStages.addRestrictionForMod('astages/mod/bells_whistles', 'steam', 'bellsandwhistles')
	.setCanBeStoredInInventory(true)
	.setCanBeStoredInContainers(true)
	.setCanPickedUp(true)
	.associateLootRestriction();
AStages.addRestrictionForMod('astages/mod/mekanism_covers', 'steam', 'mekanismcovers')
	.setCanBeStoredInInventory(true)
	.setCanBeStoredInContainers(true)
	.setCanPickedUp(true)
	.associateLootRestriction();
AStages.addRestrictionForMod('astages/mod/sliceanddice', 'steam', 'sliceanddice')
	.setCanBeStoredInInventory(true)
	.setCanBeStoredInContainers(true)
	.setCanPickedUp(true)
	.associateLootRestriction();

ServerEvents.recipes(event => {
	event.forEachRecipe({ input: "create:zinc_ingot", type: 'minecraft:crafting_shaped' }, recipe => {
		AStages.addRestrictionForRecipe(`astages/minecraft/zinc/${ recipe.getId().replace(':', '_') }`, 'steam', 'crafting', recipe.getId());
	});

	event.forEachRecipe({ input: "capylandtweak:refined_diamond_ingot", type: 'minecraft:crafting_shaped' }, recipe => {
		AStages.addRestrictionForRecipe(`astages/minecraft/refined_diamond_ingot/${ recipe.getId().replace(':', '_') }`, 'steam', 'crafting', recipe.getId());
	});
});

/*******************************************
 * Recipes you unlock in Industrial era
 *******************************************/
Capy.addRestrictionForList('industrial', [
	'pneumaticcraft:reinforced_stone_slab',
	'pneumaticcraft:reinforced_stone',
	'pneumaticcraft:reinforced_bricks',
	'pneumaticcraft:reinforced_brick_pillar',
	'pneumaticcraft:reinforced_brick_slab',
	'pneumaticcraft:reinforced_brick_stairs',
	'pneumaticcraft:reinforced_brick_tile',
	'pneumaticcraft:reinforced_brick_wall',
	'pneumaticcraft:plastic_brick_light_blue',
	'pneumaticcraft:plastic_brick_magenta',
	'pneumaticcraft:plastic_brick_light_gray',
	'pneumaticcraft:plastic_brick_green',
	'pneumaticcraft:plastic_brick_lime',
	'pneumaticcraft:plastic_brick_orange',
	'pneumaticcraft:plastic_brick_pink',
	'pneumaticcraft:plastic_brick_purple',
	'pneumaticcraft:plastic_brick_black',
	'pneumaticcraft:plastic_brick_yellow',
	'pneumaticcraft:plastic_brick_white',
	'pneumaticcraft:plastic_brick_blue',
	'pneumaticcraft:plastic_brick_brown',
	'pneumaticcraft:plastic_brick_cyan',
	'pneumaticcraft:smooth_plastic_brick_cyan',
	'pneumaticcraft:smooth_plastic_brick_brown',
	'pneumaticcraft:smooth_plastic_brick_blue',
	'pneumaticcraft:smooth_plastic_brick_yellow',
	'pneumaticcraft:smooth_plastic_brick_white',
	'pneumaticcraft:smooth_plastic_brick_red',
	'pneumaticcraft:smooth_plastic_brick_purple',
	'pneumaticcraft:smooth_plastic_brick_pink',
	'pneumaticcraft:smooth_plastic_brick_orange',
	'pneumaticcraft:smooth_plastic_brick_magenta',
	'pneumaticcraft:smooth_plastic_brick_lime',
	'pneumaticcraft:smooth_plastic_brick_light_gray',
	'pneumaticcraft:smooth_plastic_brick_light_blue',
	'pneumaticcraft:smooth_plastic_brick_green',
	'pneumaticcraft:smooth_plastic_brick_gray',
]);
AStages.addRestrictionForMod('astages/mod/ie', 'industrial', 'immersiveengineering')
	.setCanBeStoredInInventory(true)
	.setCanBeStoredInContainers(true)
	.setCanPickedUp(true)
	.ignoreItems([
		'immersiveengineering:seed',
		'immersiveengineering:hemp_fiber',

		// Treated wood (All Ages except that you need coke oven to make them)
		'immersiveengineering:crate',
		'immersiveengineering:wooden_barrel',
		'immersiveengineering:stick_treated',
		'immersiveengineering:treated_fence',
		'immersiveengineering:treated_fence_gate',
		'immersiveengineering:treated_scaffold',
		'immersiveengineering:treated_post',
		'immersiveengineering:treated_window',
		'immersiveengineering:treated_catwalk',
		'immersiveengineering:treated_catwalk_stairs',
		'immersiveengineering:treated_door',
		'immersiveengineering:treated_door_framed',
		'immersiveengineering:treated_trapdoor',
		'immersiveengineering:treated_trapdoor_framed',
		'immersiveengineering:treated_wallmount',
		'immersiveengineering:treated_wood_horizontal',
		'immersiveengineering:slab_treated_wood_horizontal',
		'immersiveengineering:stairs_treated_wood_horizontal',
		'immersiveengineering:treated_wood_vertical',
		'immersiveengineering:slab_treated_wood_vertical',
		'immersiveengineering:stairs_treated_wood_vertical',
		'immersiveengineering:treated_wood_packaged',
		'immersiveengineering:slab_treated_wood_packaged',
		'immersiveengineering:stairs_treated_wood_packaged',
		'immersiveengineering:steel_scaffolding_wooden_top',
		'immersiveengineering:alu_scaffolding_wooden_top',
		'immersiveengineering:slab_steel_scaffolding_wooden_top',
		'immersiveengineering:slab_alu_scaffolding_wooden_top',
		'immersiveengineering:stairs_steel_scaffolding_wooden_top',
		'immersiveengineering:treated_wood_sign',
		'immersiveengineering:stairs_alu_scaffolding_wooden_top',
		'immersiveengineering:treated_wood_hanging_sign',

		// Kiln stuff
		'immersiveengineering:alloybrick',
		'immersiveengineering:slab_alloybrick',
		'immersiveengineering:alloy_smelter',

		// Coke Oven stuff
		'immersiveengineering:coal_coke',
		'immersiveengineering:dust_coke',
		'immersiveengineering:cokebrick',
		'immersiveengineering:coke',
		'immersiveengineering:slab_cokebrick',
		'immersiveengineering:slab_coke',
		'immersiveengineering:coke_oven',

		// Fluid stuff
		'immersiveengineering:fluid_pump',
		'immersiveengineering:fluid_placer',
		'immersiveengineering:fluid_pipe',
		'immersiveengineering:tank',

		// Iron stuff
		'immersiveengineering:plate_iron',
		'immersiveengineering:stick_iron',
		'immersiveengineering:drillhead_iron',
		'immersiveengineering:component_iron',
		'immersiveengineering:sheetmetal_iron',
		'immersiveengineering:slab_sheetmetal_iron',
		'immersiveengineering:chute_iron',
		'immersiveengineering:hammer',
		'immersiveengineering:wirecutter',
		'immersiveengineering:screwdriver',

		// Silver stuff
		'immersiveengineering:ingot_silver',
		'immersiveengineering:nugget_silver',
		'immersiveengineering:plate_silver',
		'immersiveengineering:dust_silver',
		'immersiveengineering:sheetmetal_silver',
		'immersiveengineering:slab_sheetmetal_silver',
		'immersiveengineering:raw_block_silver',
		'immersiveengineering:storage_silver',
		'immersiveengineering:slab_storage_silver',

		// Gold stuff
		'immersiveengineering:plate_gold',
		'immersiveengineering:sheetmetal_gold',
		'immersiveengineering:slab_sheetmetal_gold',

		// Steel stuff
		'mekanism:dust_steel',
		'mekanism:ingot_steel',
		'mekanism:nugget_steel',
		'mekanism:block_steel',
		'mekanism:steel_casing',

		'immersiveengineering:stick_steel',
		'immersiveengineering:component_steel',
		'immersiveengineering:wire_steel',
		'immersiveengineering:plate_steel',
		'immersiveengineering:pickaxe_steel',
		'immersiveengineering:shovel_steel',
		'immersiveengineering:axe_steel',
		'immersiveengineering:hoe_steel',
		'immersiveengineering:sword_steel',
		'immersiveengineering:drillhead_steel',
		'immersiveengineering:armor_steel_helmet',
		'immersiveengineering:armor_steel_chestplate',
		'immersiveengineering:armor_steel_leggings',
		'immersiveengineering:armor_steel_boots',
		'immersiveengineering:steel_fence',
		'immersiveengineering:steel_fence_gate',
		'immersiveengineering:steel_wallmount',
		'immersiveengineering:steel_post',
		'immersiveengineering:steel_slope',
		'immersiveengineering:steel_window',
		'immersiveengineering:steel_catwalk',
		'immersiveengineering:steel_catwalk_stairs',
		'immersiveengineering:steel_door',
		'immersiveengineering:steel_trapdoor',
		'immersiveengineering:sheetmetal_steel',
		'immersiveengineering:slab_sheetmetal_steel',
		'immersiveengineering:slab_storage_steel',
		'immersiveengineering:metal_ladder_steel',
		'immersiveengineering:steel_scaffolding_standard',
		'immersiveengineering:slab_steel_scaffolding_standard',
		'immersiveengineering:stairs_steel_scaffolding_standard',
		'immersiveengineering:steel_scaffolding_grate_top',
		'immersiveengineering:slab_steel_scaffolding_grate_top',
		'immersiveengineering:stairs_steel_scaffolding_grate_top',
		'immersiveengineering:steel_scaffolding_wooden_top',
		'immersiveengineering:slab_steel_scaffolding_wooden_top',
		'immersiveengineering:stairs_steel_scaffolding_wooden_top',
		'immersiveengineering:chute_steel',
		'immersiveengineering:steel_sign',
		'immersiveengineering:steel_hanging_sign',

		// Ores
		'immersiveengineering:ore_aluminum',
		'immersiveengineering:deepslate_ore_aluminum',
		'immersiveengineering:ore_lead',
		'immersiveengineering:ore_silver',
		'immersiveengineering:deepslate_ore_silver',
		'immersiveengineering:ore_nickel'
	])
	.associateLootRestriction();
AStages.addRestrictionForMod('astages/mod/cooking_for_blockhead', 'industrial', 'cookingforblockheads')
	.setCanBeStoredInInventory(true)
	.setCanBeStoredInContainers(true)
	.setCanPickedUp(true)
	.associateLootRestriction();
AStages.addRestrictionForMod('astages/mod/manofmanyplanes', 'industrial', 'man_of_many_planes')
	.setCanBeStoredInInventory(true)
	.setCanBeStoredInContainers(true)
	.setCanPickedUp(true)
	.associateLootRestriction();

ServerEvents.recipes(event => {
	event.forEachRecipe({ input: "oritech:electrum_ingot", type: 'minecraft:crafting_shaped' }, recipe => {
		AStages.addRestrictionForRecipe(`astages/minecraft/electrum/${ recipe.getId().replace(':', '_') }`, 'industrial', 'crafting', recipe.getId());
	});
});

/*******************************************
 * Recipes you unlock in Electronic era
 *******************************************/
AStages.addRestrictionForMod('astages/mod/pneumaticcraft', 'electronic', 'pneumaticcraft') // Pneumatic Craft
 	.setCanBeStoredInInventory(true)
 	.setCanBeStoredInContainers(true)
	.setCanPickedUp(true)
	.ignoreItems(
		'pneumaticcraft:omnidirectional_hopper',

		// Pneumatic Legos
		'pneumaticcraft:reinforced_stone_slab',
		'pneumaticcraft:reinforced_stone',
		'pneumaticcraft:reinforced_bricks',
		'pneumaticcraft:reinforced_brick_pillar',
		'pneumaticcraft:reinforced_brick_slab',
		'pneumaticcraft:reinforced_brick_stairs',
		'pneumaticcraft:reinforced_brick_tile',
		'pneumaticcraft:reinforced_brick_wall',
		'pneumaticcraft:plastic_brick_light_blue',
		'pneumaticcraft:plastic_brick_magenta',
		'pneumaticcraft:plastic_brick_light_gray',
		'pneumaticcraft:plastic_brick_green',
		'pneumaticcraft:plastic_brick_lime',
		'pneumaticcraft:plastic_brick_orange',
		'pneumaticcraft:plastic_brick_pink',
		'pneumaticcraft:plastic_brick_purple',
		'pneumaticcraft:plastic_brick_black',
		'pneumaticcraft:plastic_brick_yellow',
		'pneumaticcraft:plastic_brick_white',
		'pneumaticcraft:plastic_brick_blue',
		'pneumaticcraft:plastic_brick_brown',
		'pneumaticcraft:plastic_brick_cyan',
		'pneumaticcraft:smooth_plastic_brick_cyan',
		'pneumaticcraft:smooth_plastic_brick_brown',
		'pneumaticcraft:smooth_plastic_brick_blue',
		'pneumaticcraft:smooth_plastic_brick_yellow',
		'pneumaticcraft:smooth_plastic_brick_white',
		'pneumaticcraft:smooth_plastic_brick_red',
		'pneumaticcraft:smooth_plastic_brick_purple',
		'pneumaticcraft:smooth_plastic_brick_pink',
		'pneumaticcraft:smooth_plastic_brick_orange',
		'pneumaticcraft:smooth_plastic_brick_magenta',
		'pneumaticcraft:smooth_plastic_brick_lime',
		'pneumaticcraft:smooth_plastic_brick_light_gray',
		'pneumaticcraft:smooth_plastic_brick_light_blue',
		'pneumaticcraft:smooth_plastic_brick_green',
		'pneumaticcraft:smooth_plastic_brick_gray',

		// All Ages
		'pneumaticcraft:compressed_brick_stairs',
		'pneumaticcraft:compressed_brick_tile',
		'pneumaticcraft:compressed_brick_wall',
		'pneumaticcraft:compressed_bricks',
		'pneumaticcraft:compressed_stone_slab',
		'pneumaticcraft:compressed_stone',
		'pneumaticcraft:compressed_brick_slab',

		// Food
		'pneumaticcraft:raw_salmon_tempura',
		'pneumaticcraft:bandage',
		'pneumaticcraft:sourdough_bread',
		'pneumaticcraft:chips',
		'pneumaticcraft:cod_n_chips',
		'pneumaticcraft:salmon_tempura',
		'pneumaticcraft:sourdough'
	).associateLootRestriction();
AStages.addRestrictionForMod('astages/mod/refined_storage', 'electronic', 'refinedstorage')
	.setCanBeStoredInInventory(true)
	.setCanBeStoredInContainers(true)
	.setCanPickedUp(true)
	.associateLootRestriction();
AStages.addRestrictionForMod('astages/mod/railwaysnavigator', 'electronic', 'railwaysnavigator')
	.setCanBeStoredInInventory(true)
	.setCanBeStoredInContainers(true)
	.setCanPickedUp(true)
	.associateLootRestriction();
AStages.addRestrictionForMod('astages/mod/ae2', 'electronic', 'ae2') // Applied energitic 2
	.setCanBeStoredInInventory(true)
	.setCanBeStoredInContainers(true)
	.setCanPickedUp(true)
	.associateLootRestriction();
AStages.addRestrictionForMod('astages/mod/mekanism', 'electronic', 'mekanism') // Mekanism
	.setCanBeStoredInInventory(true)
	.setCanBeStoredInContainers(true)
	.setCanPickedUp(true)
	.ignoreItems(
		// Tin
		'mekanism:enriched_tin',
		'mekanism:shard_tin',
		'mekanism:crystal_tin',
		'mekanism:dust_tin',
		'mekanism:dirty_dust_tin',
		'mekanism:clump_tin',
		'mekanism:ingot_tin',
		'mekanism:raw_tin',
		'mekanism:nugget_tin',
		'mekanism:tin_ore',
		"mekanism:block_salt",

		'mekanism:deepslate_tin_ore',
		'mekanism:uranium_ore',
		'mekanism:deepslate_uranium_ore',
		'mekanism:osmium_ore',
		'mekanism:deepslate_osmium_ore',
		'mekanism:fluorite_ore',
		'mekanism:deepslate_fluorite_ore',
		'mekanism:lead_ore',
		'mekanism:deepslate_lead_ore',

		// More Ore Components
		'mekanism:enriched_carbon',
		'mekanism:enriched_redstone',
		'mekanism:enriched_diamond',
		'mekanism:enriched_refined_obsidian',
		'mekanism:enriched_gold',
		'mekanism:enriched_tin',
		'mekanism:enriched_iron',
		'mekanism:sawdust',
		'mekanism:substrate',
		'mekanism:bio_fuel',
		'mekanism:dye_base',
		'mekanism:fluorite_gem',
		'mekanism:dirty_netherite_scrap',
		'mekanism:dust_lapis_lazuli',
		'mekanism:dust_charcoal',
		'mekanism:dust_quartz',
		'mekanism:dust_emerald',
		'mekanism:dust_diamond',
		'mekanism:dust_netherite',
		'mekanism:dust_sulfur',
		'mekanism:dust_lithium',
		'mekanism:dust_refined_obsidian',
		'mekanism:dust_obsidian',
		'mekanism:dust_fluorite',
		'mekanism:shard_iron',
		'mekanism:shard_gold',
		'mekanism:shard_osmium',
		'mekanism:shard_copper',
		'mekanism:shard_tin',
		'mekanism:shard_lead',
		'mekanism:shard_uranium',
		'mekanism:crystal_osmium',
		'mekanism:crystal_iron',
		'mekanism:crystal_gold',
		'mekanism:crystal_copper',
		'mekanism:crystal_tin',
		'mekanism:crystal_lead',
		'mekanism:crystal_uranium',
		'mekanism:dust_osmium',
		'mekanism:dust_tin',
		'mekanism:dust_lead',
		'mekanism:dirty_dust_iron',
		'mekanism:dirty_dust_gold',
		'mekanism:dirty_dust_osmium',
		'mekanism:dirty_dust_copper',
		'mekanism:dirty_dust_tin',
		'mekanism:dirty_dust_lead',
		'mekanism:dirty_dust_uranium',
		'mekanism:clump_osmium',
		'mekanism:clump_tin',
		'mekanism:clump_lead',
		'mekanism:clump_uranium',
		'mekanism:raw_osmium',
		'mekanism:raw_tin',
		'mekanism:raw_lead',
		'mekanism:nugget_osmium',
		'mekanism:nugget_tin',
		'mekanism:nugget_lead',
		'mekanism:nugget_uranium',

		// Bronze
		'mekanism:dust_bronze',
		'mekanism:ingot_bronze',
		'mekanism:nugget_bronze',
		'mekanism:block_bronze',

		'mekanism:basic_universal_cable',

		// Allow fluid
		'mekanism:basic_fluid_tank',
		'mekanism:advanced_fluid_tank',
		'mekanism:elite_fluid_tank',
		'mekanism:ultimate_fluid_tank',
		'mekanism:creative_fluid_tank',
	).associateLootRestriction();
AStages.addRestrictionForMod('astages/mod/mekanismgenerators', 'electronic', 'mekanismgenerators') // Mekanism Generators
	.setCanBeStoredInInventory(true)
	.setCanBeStoredInContainers(true)
	.setCanPickedUp(true)
	.ignoreItems(
		'mekanismgenerators:wind_generator',
		'mekanismgenerators:solar_panel',
		'mekanismgenerators:solar_generator',
		'mekanismgenerators:advanced_solar_generator',
		'mekanismgenerators:heat_generator',
		'mekanismgenerators:gas_burning_generator',
		'mekanismgenerators:bio_generator'
	).associateLootRestriction(); // Various energy generators that are not too advanced and should be lower
Capy.addRestrictionForList('electronic', [
	'pneumaticcraft:collector_drone',
	'pneumaticcraft:pneumatic_boots',
	'pneumaticcraft:pneumatic_helmet',
	'pneumaticcraft:pneumatic_chestplate',
	'pneumaticcraft:pneumatic_leggings',

	// Mekanism Gear
	'mekanismtools:refined_glowstone_pickaxe',
	'mekanismtools:refined_glowstone_axe',
	'mekanismtools:refined_glowstone_shovel',
	'mekanismtools:refined_glowstone_hoe',
	'mekanismtools:refined_glowstone_sword',
	'mekanismtools:refined_glowstone_paxel',
	'mekanismtools:refined_glowstone_helmet',
	'mekanismtools:refined_glowstone_chestplate',
	'mekanismtools:refined_glowstone_leggings',
	'mekanismtools:refined_glowstone_boots',
	'mekanismtools:refined_obsidian_pickaxe',
	'mekanismtools:refined_obsidian_axe',
	'mekanismtools:refined_obsidian_shovel',
	'mekanismtools:refined_obsidian_hoe',
	'mekanismtools:refined_obsidian_sword',
	'mekanismtools:refined_obsidian_paxel',
	'mekanismtools:refined_obsidian_helmet',
	'mekanismtools:refined_obsidian_leggings',
	'mekanismtools:refined_obsidian_chestplate',
	'mekanismtools:refined_obsidian_boots'
]);
AStages.addRestrictionForMod('astages/mod/cctweak', 'electronic', 'computercraft') // Computer craft
	.setCanBeStoredInInventory(true)
	.setCanBeStoredInContainers(true)
	.setCanPickedUp(true)
	.associateLootRestriction();

/*******************************************
 * Recipes you unlock in Futuristic era
 *******************************************/
AStages.addRestrictionForMod('astages/mod/oritech', 'futuristic', 'oritech') // Extreme Reactors
	.setCanBeStoredInInventory(true)
	.setCanBeStoredInContainers(true)
	.setCanPickedUp(true)
	.ignoreItems(
		// Ores
		'oritech:deepslate_uranium_ore',
		'oritech:deepslate_platinum_ore',
		'oritech:endstone_platinum_ore',
		'oritech:nickel_ore',
		'oritech:deepslate_nickel_ore',

		// Early Oritech
		'oritech:assembler_block',
		'oritech:foundry_block',
		'oritech:machine_core_3',
		'oritech:machine_core_4',
		'oritech:machine_core_5',
		'oritech:machine_core_6',
		'oritech:machine_core_7',
		'oritech:superconductor',

		// Ore components
		'oritech:raw_nickel',
		'oritech:nickel_clump',
		'oritech:small_nickel_clump',
		'oritech:nickel_dust',
		'oritech:small_nickel_dust',
		'oritech:nickel_gem',
		'oritech:nickel_nugget',
		'oritech:platinum_ingot',
		'oritech:raw_platinum',
		'oritech:nickel_ingot',
		'oritech:platinum_clump',
		'oritech:small_platinum_clump',
		'oritech:platinum_dust',
		'oritech:small_platinum_dust',
		'oritech:platinum_gem',
		'oritech:platinum_nugget',
		'oritech:iron_clump',
		'oritech:small_iron_clump',
		'oritech:iron_dust',
		'oritech:small_iron_dust',
		'oritech:iron_gem',
		'oritech:copper_clump',
		'oritech:small_copper_clump',
		'oritech:copper_dust',
		'oritech:small_copper_dust',
		'oritech:copper_gem',
		'oritech:copper_nugget',
		'oritech:gold_clump',
		'oritech:small_gold_clump',
		'oritech:gold_dust',
		'oritech:small_gold_dust',
		'oritech:gold_gem',
		'oritech:fluxite',
		'oritech:electrum_ingot',
		'oritech:electrum_dust',

		'oritech:adamant_ingot',
		'oritech:adamant_dust',
		'oritech:duratium_ingot',
		'oritech:duratium_dust',
		'oritech:energite_ingot',
		'oritech:energite_dust',
		'oritech:prometheum_ingot',
		'oritech:steel_ingot',
		'oritech:steel_dust',
		'oritech:coal_dust',
		'oritech:carbon_fibre_strands',
		'oritech:enderic_compound',
		'oritech:quartz_dust',
		'oritech:biomass',
		'oritech:raw_uranium',
		'oritech:uranium_gem',
		'oritech:small_uranium_dust',
		'oritech:uranium_dust',
		'oritech:small_plutonium_dust',
		'oritech:plutonium_dust',
	).associateLootRestriction();
