let CAPY_RECIPE_FLAGS = {
	SMELT:  1 << 0,
	CRUDE:  1 << 1,
	ADV:    1 << 2,
	ARC:    1 << 3,
	MK:     1 << 4,
	COPY:   1 << 5,
	NO_MK:  1 << 6,
}

ServerEvents.recipes(event => {
	let R = CAPY_RECIPE_FLAGS;


	/*
	* Furnace Recipes
	*/
	// Idk why I went with flags
	let recipeList = {
		// Copies
		'oritech:copper_nugget_from_smelting_small_copper_dust':                                   { F: R.CRUDE | R.COPY | R.NO_MK, O: {}          },
		'mekanism:processing/copper/ingot/from_dust_blasting':                                     { F: R.CRUDE | R.COPY | R.NO_MK, O: {}          },
		'mekanism:processing/copper/ingot/from_dust_blasting':                                     { F: R.CRUDE | R.COPY | R.NO_MK, O: {}          },
		'mekanism:processing/tin/ingot/from_dust_blasting':                                        { F: R.CRUDE | R.COPY | R.NO_MK, O: {}          },
		'mekanism:processing/tin/ingot/from_dust_blasting':                                        { F: R.CRUDE | R.COPY | R.NO_MK, O: {}          },
		'mekanism:processing/iron/ingot/from_dust_blasting':                                       { F: R.CRUDE | R.COPY | R.NO_MK, O: {}          },
		'mekanism:processing/iron/ingot/from_dust_blasting':                                       { F: R.CRUDE | R.COPY | R.NO_MK, O: {}          },
		'mekanism:processing/lead/ingot/from_dust_blasting':                                       { F: R.CRUDE | R.COPY | R.NO_MK, O: {}          },
		'mekanism:processing/lead/ingot/from_dust_blasting':                                       { F: R.CRUDE | R.COPY | R.NO_MK, O: {}          },
		'oritech:adamant_ingot_from_smelting_adamant_dust':                                        { F: R.CRUDE | R.COPY | R.NO_MK, O: {}          },
		'oritech:nickel_ingot_from_smelting_nickel_gem':                                           { F: R.CRUDE | R.COPY | R.NO_MK, O: {}          },
		'oritech:nickel_ingot_from_smelting_nickel_gem':                                           { F: R.CRUDE | R.COPY | R.NO_MK, O: {}          },

		// Crucible -> Smelt
		'minecraft:nether_brick':                                                                  { F: R.SMELT, O: {}                             },
		'pneumaticcraft:plastic_sheet_from_brick':                                                 { F: R.SMELT, O: {}                             },
		'pneumaticcraft:plastic_sheet_from_smooth_brick':                                          { F: R.SMELT, O: {}                             },

		'oritech:nickel_ingot_from_smelting_raw_nickel':                                           { F: R.CRUDE, O: {}                             },
		'oritech:nickel_ingot_from_smelting_nickel_dust':                                          { F: R.CRUDE, O: {}                             },
		'immersiveengineering:smelting/ingot_nickel':                                              { F: R.CRUDE, O: {}                             },
		'oritech:steel_ingot_from_smelting_steel_dust':                                            { F: R.CRUDE, O: {}                             },
		'oritech:steel_ingot_from_smelting_steel_dust':                                            { F: R.CRUDE, O: {}                             },
		'oritech:steel_ingot_from_smelting_steel_dust':                                            { F: R.CRUDE, O: {}                             },
		'mekanismtools:bronze/nugget_from_smelting':                                               { F: R.CRUDE, O: {}                             },
		'oritech:nickel_nugget_from_smelting_small_nickel_dust':                                   { F: R.CRUDE, O: {}                             },
		'oritech:platinum_nugget_from_smelting_small_platinum_dust':                               { F: R.CRUDE, O: {}                             },

		'minecraft:gold_nugget_from_blasting':                                                     { F: R.CRUDE, O: {}                             },
		'minecraft:gold_ingot_from_blasting_deepslate_gold_ore':                                   { F: R.CRUDE, O: { experience: true           } },
		'minecraft:gold_ingot_from_blasting_raw_gold':                                             { F: R.CRUDE, O: { experience: true           } },
		'mekanism:processing/gold/ingot/from_dust_blasting':                                       { F: R.CRUDE, O: { experience: false          } },
		'create:blasting/gold_ingot_from_crushed':                                                 { F: R.CRUDE, O: { experience: false          } },
		'mekanism:processing/steel/ingot/from_dust_blasting':                                      { F: R.CRUDE, O: { experience: false          } },
		'magistuarmory:furnace/steel_nugget_blasting':                                             { F: R.CRUDE, O: { experience: false          } },
		'magistuarmoryaddon:furnace/steel_nugget_blasting':                                        { F: R.CRUDE, O: { experience: false          } },
		'immersiveengineering:smelting/nugget_steel_recycle_pick_from_blasting':                   { F: R.CRUDE, O: { experience: false          } },
		'immersiveengineering:smelting/nugget_steel_recycle_shovel_from_blasting':                 { F: R.CRUDE, O: { experience: false          } },
		'immersiveengineering:smelting/nugget_steel_recycle_axe_from_blasting':                    { F: R.CRUDE, O: { experience: false          } },
		'immersiveengineering:smelting/nugget_steel_recycle_sword_from_blasting':                  { F: R.CRUDE, O: { experience: false          } },
		'immersiveengineering:smelting/nugget_steel_recycle_steel_helmet_from_blasting':           { F: R.CRUDE, O: { experience: false          } },
		'immersiveengineering:smelting/nugget_steel_recycle_steel_chestplate_from_blasting':       { F: R.CRUDE, O: { experience: false          } },
		'immersiveengineering:smelting/nugget_steel_recycle_steel_leggings_from_blasting':         { F: R.CRUDE, O: { experience: false          } },
		'immersiveengineering:smelting/nugget_steel_recycle_steel_boots_from_blasting':            { F: R.CRUDE, O: { experience: false          } },
		'create:blasting/zinc_ingot_from_raw_ore':                                                 { F: R.CRUDE, O: { experience: true           } },
		'create:blasting/zinc_ingot_from_crushed':                                                 { F: R.CRUDE, O: { experience: false          } },
		'create:blasting/zinc_ingot_from_ore':                                                     { F: R.CRUDE, O: { experience: true           } },
		'immersiveengineering:smelting/ingot_aluminum_from_blasting3':                             { F: R.ADV,   O: { experience: true           } },
		'immersiveengineering:smelting/ingot_aluminum_from_dust_from_blasting':                    { F: R.ADV,   O: { experience: false          } },
		'immersiveengineering:smelting/ingot_aluminum_from_blasting':                              { F: R.ADV,   O: { experience: true           } },
		'immersiveengineering:smelting/ingot_silver_from_blasting3':                               { F: R.ADV,   O: { experience: true           } },
		'immersiveengineering:smelting/ingot_silver_from_dust_from_blasting':                      { F: R.ADV,   O: { experience: false          } },
		'immersiveengineering:smelting/ingot_silver_from_blasting':                                { F: R.ADV,   O: { experience: true           } },
		'immersiveengineering:smelting/nugget_aluminum_recycle_faraday_helmet_from_blasting':      { F: R.ADV,   O: { experience: false          } },
		'immersiveengineering:smelting/nugget_aluminum_recycle_faraday_chestplate_from_blasting':  { F: R.ADV,   O: { experience: false          } },
		'immersiveengineering:smelting/nugget_aluminum_recycle_faraday_leggings_from_blasting':    { F: R.ADV,   O: { experience: false          } },
		'immersiveengineering:smelting/nugget_aluminum_recycle_faraday_boots_from_blasting':       { F: R.ADV,   O: { experience: false          } },
		'minecraft:emerald_from_blasting_deepslate_emerald_ore':                                   { F: R.ADV,   O: { experience: true           } },
		'minecraft:diamond_from_blasting_deepslate_diamond_ore':                                   { F: R.ADV,   O: { experience: true           } },
		'mowziesmobs:grottol_blast':                                                               { F: R.ADV,   O: { experience: true           } },
		// mekanism:processing/osmium/ingot/from_dust_blasting':                                     { F: R.ADV,   O: { experience: false          } },
		// mekanism:processing/osmium/ingot/from_raw_blasting':                                      { F: R.ADV,   O: { experience: true           } },
		// mekanism:processing/osmium/ingot/from_ore_blasting':                                      { F: R.ADV,   O: { experience: true           } },
		'mekanismtools:osmium/nugget_from_blasting':                                               { F: R.ADV,   O: { experience: false,         } },
		'mekanismtools:refined_obsidian/nugget_from_blasting':                                     { F: R.ARC,   O: { experience: false,         } },
		'mekanismtools:refined_glowstone/nugget_from_blasting':                                    { F: R.ARC,   O: { experience: false,         } },
		'minecraft:netherite_scrap_from_blasting': 				                                   { F: R.ARC,   O: { experience: true, count: 3 } },
		'mekanism:processing/netherite/ingot_from_dust_blasting':                                  { F: R.ARC,   O: { experience: false,count: 3 } },
		'mekanism:processing/uranium/ingot/from_dust_blasting':                                    { F: R.ARC,   O: { experience: false,         } },
		'tfmg:blasting/lithium_ingot_blasting':                                                    { F: R.ARC,   O: { experience: true,          } },
		'tfmg:blasting/lithium_ingot_from_crushed_blasting':                                       { F: R.ARC,   O: { experience: false,         } },

		// To remove
		'minecraft:emerald_from_smelting_deepslate_emerald_ore':                    null, // Feudal Era
		'minecraft:diamond_from_smelting_deepslate_diamond_ore':                    null, // Feudal Era
		'minecraft:gold_ingot_from_smelting_deepslate_gold_ore':                    null, // Feudal Era
		'minecraft:gold_ingot_from_smelting_raw_gold':                              null, // Feudal Era
		'minecraft:iron_ingot_from_smelting_raw_iron':                              null, // Iron Era
		'minecraft:iron_ingot_from_smelting_deepslate_iron_ore':                    null, // Iron Era
		'minecraft:gold_nugget_from_smelting':                                      null, // Feudal Era
		'minecraft:iron_nugget_from_smelting':                                      null, // Iron Era
		'minecraft:quartz':                                                         null, // Iron Era idk
		'minecraft:nether_brick':                                                   null, // Steam Era
		'minecraft:netherite_scrap':                                                null, // Steam Era
		'magistuarmory:furnace/steel_ingot_blasting':                               null, // Feudal Era
		'create:smelting/ingot_uranium_compat_immersiveengineering':                null, // Industrial Era
		'create:smelting/ingot_uranium_compat_mekanism':                            null, // Industrial Era
		'immersiveengineering:smelting/ingot_uranium':                              null, // Industrial Era
		'immersiveengineering:smelting/ingot_uranium':                              null, // Industrial Era
		'immersiveengineering:smelting/ingot_uranium3':                             null, // Industrial Era
		'immersiveengineering:smelting/ingot_aluminum':                             null,
		'immersiveengineering:smelting/ingot_aluminum3':                            null,
		'immersiveengineering:smelting/ingot_aluminum_from_dust':                   null,
		'immersiveengineering:smelting/ingot_silver3':                              null,
		'immersiveengineering:smelting/ingot_silver':                               null,
		'immersiveengineering:smelting/ingot_silver_from_dust':                     null,
		'immersiveengineering:smelting/ingot_electrum_from_dust':                   null,
		'tfmg:blasting/nickel_ingot_from_crushed_blasting':                         null,
		'create:smelting/ingot_nickel_compat_immersiveengineering':                 null,
		'nickel_ingot_from_crushed_blasting':                                       null,
		'immersiveengineering:smelting/nugget_steel_recycle_sword':                 null,
		'immersiveengineering:smelting/nugget_steel_recycle_steel_chestplate':      null,
		'immersiveengineering:smelting/nugget_steel_recycle_shovel':                null,
		'immersiveengineering:smelting/nugget_steel_recycle_steel_boots':           null,
		'immersiveengineering:smelting/nugget_steel_recycle_steel_leggings':        null,
		'immersiveengineering:smelting/nugget_steel_recycle_steel_helmet':          null,
		'immersiveengineering:smelting/nugget_steel_recycle_pick':                  null,
		'immersiveengineering:smelting/nugget_steel_recycle_axe':                   null,
		'mekanism:processing/osmium/ingot/from_dust_smelting':                      null,
		'mekanismtools:steel/nugget_from_smelting':                                 null,
		'mekanismtools:osmium/nugget_from_smelting':                                null,
		'mekanismtools:iron_nugget_from_smelting':                                  null,
		'mekanismtools:gold_nugget_from_smelting':                                  null,
		'mekanismtools:refined_obsidian/nugget_from_smelting':                      null,
		'mekanismtools:refined_glowstone/nugget_from_smelting':                     null,
		'tfmg:smelting/lithium_ingot_blasting':                                     null,
		'tfmg:smelting/lithium_ingot_from_crushed_blasting':                        null,
		'tfmg:smelting/lithium_ingot':                                              null,
		'immersiveengineering:smelting/nugget_aluminum_recycle_faraday_leggings':   null,
		'immersiveengineering:smelting/nugget_aluminum_recycle_faraday_helmet':     null,
		'immersiveengineering:smelting/nugget_aluminum_recycle_faraday_boots':      null,
		'immersiveengineering:smelting/nugget_aluminum_recycle_faraday_chestplate': null,
		'immersiveengineering:smelting/ingot_constantan_from_dust':                 null, // Bronze
		'mekanismtools:steel/nugget_from_blasting':                                 null,
		'mekanism:processing/uranium/ingot/from_ore_blasting':                      null,
		'create:blasting/ingot_uranium_compat_immersiveengineering':                null,
		'create:blasting/ingot_nickel_compat_immersiveengineering':                 null,
		'create:smelting/ingot_osmium_compat_mekanism':                             null,
		'create:smelting/ingot_aluminum_compat_immersiveengineering':               null,
		'create:smelting/ingot_silver_compat_immersiveengineering':                 null,
		'mowziesmobs:grottol_smelt':                                                null,
		'mekanism:processing/uranium/ingot/from_dust_smelting':                     null,
		'mekanism:processing/steel/ingot/from_dust_smelting':                       null,
		'mekanism:processing/osmium/ingot/from_raw_smelting':                       null,
		'mekanism:processing/gold/ingot/from_dust_smelting':                        null,
		'mekanism:processing/iron/ingot/from_dust_smelting':                        null,
		'mekanism:processing/bronze/ingot/from_dust_smelting':                      null,
		'mekanism:processing/tin/ingot/from_dust_smelting':                         null,
		'mekanism:processing/uranium/ingot/from_ore_smelting':                      null,
		'mekanism:processing/osmium/ingot/from_ore_smelting':                       null,
		'mekanism:processing/netherite/ingot_from_dust_smelting':                   null,
		'minecolonies:iron_nugget_from_iron_scimitar_smelting':                     null,
		'farmersdelight:iron_nugget_from_smelting_knife':                           null,
		'farmersdelight:gold_nugget_from_smelting_knife':                           null,
		'farmersdelight:gold_nugget_from_smelting_knife':                           null,
		'create:smelting/gold_ingot_from_crushed':                                  null,
		'create:smelting/iron_ingot_from_crushed':                                  null,
		'create:smelting/zinc_ingot_from_ore':                                      null,
		'create:smelting/zinc_ingot_from_crushed':                                  null,
		'create:smelting/zinc_ingot_from_raw_ore':                                  null,
		'immersiveengineering:arcfurnace/steel':                                    null,
		'immersivepetroleum:arcfurnace/steel':                                      null,
		'create:blasting/ingot_osmium_compat_mekanism':                             null,
		'oritech:compat/immersiveengineering/alloying/platinumgem':                 null,
		'oritech:platinum_ingot_from_smelting_raw_platinum':                        null,
		'oritech:platinum_ingot_from_smelting_platinum_dust':                       null,
		'oritech:platinum_ingot_from_smelting_platinum_gem':                        null,
		'oritech:platinum_ingot_from_blasting_raw_platinum':                        null,
		'oritech:platinum_ingot_from_blasting_platinum_dust':                       null,
		'oritech:platinum_ingot_from_blasting_platinum_gem':                        null,
		'oritech:blasting/compat/create/crushed_platinum_to_platinum_ingot':        null,
		'oritech:duratium_ingot_from_smelting_duratium_dust':                       null,
		'oritech:duratium_ingot_from_blasting_duratium_dust':                       null,
		'oritech:compat/immersiveengineering/alloying/duratium':                    null,
		'immersiveengineering:smelting/ingot_electrum_from_dust_from_blasting':     null,
		'immersiveengineering:alloysmelter/electrum':                               null,
		'oritech:electrum_ingot_from_smelting_electrum_dust':                       null,
		'oritech:electrum_ingot_from_blasting_electrum_dust':                       null,
		'oritech:compat/immersiveengineering/alloying/electrum':                    null,
		'oritech:compat/immersiveengineering/arcalloying/electrum':                 null,
		'oritech:mixing/compat/create/electrum':                                    null,
		'oritech:nickel_ingot_from_smelting_raw_nickel':                            null,
		'oritech:nickel_ingot_from_smelting_nickel_dust':                           null,
		'oritech:nickel_ingot_from_smelting_nickel_gem':                            null,
		'oritech:energite_ingot_from_smelting_energite_dust':                       null,
		'oritech:energite_ingot_from_blasting_energite_dust':                       null,
		'immersiveengineering:smelting/ingot_nickel':                               null,
		'oritech:compat/immersiveengineering/alloying/biosteel':                    null,
		'oritech:biosteel_ingot_from_smelting_biosteel_dust':                       null,
		'oritech:biosteel_ingot_from_blasting_biosteel_dust':                       null,
		'oritech:iron_ingot_from_smelting_iron_dust':                               null,
		'oritech:iron_ingot_from_smelting_iron_gem':                                null,
		'oritech:compat/immersiveengineering/alloying/irongem':                     null,
		'oritech:iron_nugget_from_smelting_small_iron_dust':                        null,
		'oritech:mixing/compat/create/biosteel':                                    null,
		'immersiveengineering:arcfurnace/dust_steel':                               null,
		'oritech:compat/immersiveengineering/arcalloying/biosteel':                 null,
		'oritech:mixing/compat/create/adamant':                                     null,
		'oritech:mixing/compat/create/adamant':                                     null,
		'oritech:adamant_ingot_from_blasting_adamant_dust':                         null,
		'oritech:compat/immersiveengineering/alloying/adamant':                     null,
		'create:smelting/ingot_lead_compat_immersiveengineering':                   null, // Duplicate
		'create:smelting/ingot_lead_compat_mekanism':                               null, // Duplicate
		'create:blasting/ingot_lead_compat_immersiveengineering':                   null, // Duplicate
		'create:blasting/ingot_lead_compat_mekanism':                               null, // Duplicate
		'create:blasting/ingot_tin_compat_mekanism':                                null, // Duplicate
		'create:blasting/ingot_uranium_compat_mekanism':                            null, // Duplicate
		'create:blasting/ingot_aluminum_compat_immersiveengineering':               null, // Duplicate
		'create:blasting/ingot_silver_compat_immersiveengineering':                 null, // Duplicate
		'mekanism:processing/osmium/ingot/from_dust_blasting':                      null, // Duplicate,
		'mekanism:processing/osmium/ingot/from_raw_blasting':                       null, // Duplicate,
		'mekanism:processing/osmium/ingot/from_ore_blasting':                       null  // Duplicate,
	}

	for (let [rid, obj] of Object.entries(recipeList)) {
		// Simply remove
		if (!obj) {
			event.remove({ id: rid });
			continue;
		}

		let F = obj.F;

		switch (true) {
			case !!(F & R.SMELT):
				Capy.copyRecipeToType(event, 'minecraft:blasting',                 [rid], obj.O);
				Capy.copyRecipeToType(event, 'immersiveengineering:blast_furnace', [rid], obj.O);
				Capy.copyRecipeToType(event, 'capylandtweak:adv_blast_furnace',    [rid], obj.O);
				Capy.copyRecipeToType(event, 'immersiveengineering:arc_furnace',   [rid], obj.O);
				!!(F & R.NO_MK) && Capy.copyRecipeToType(event, 'mekanism:smelting', [rid], obj.O);
				break;
			case !!(F & R.CRUDE):
				Capy.copyRecipeToType(event, 'immersiveengineering:blast_furnace', [rid], obj.O);
				Capy.copyRecipeToType(event, 'capylandtweak:adv_blast_furnace',    [rid], obj.O);
				Capy.copyRecipeToType(event, 'immersiveengineering:arc_furnace',   [rid], obj.O);
				!!(F & R.NO_MK) && Capy.copyRecipeToType(event, 'mekanism:smelting', [rid], obj.O);
				break;
			case !!(F & R.ADV):
				Capy.copyRecipeToType(event, 'capylandtweak:adv_blast_furnace',    [rid], obj.O);
				Capy.copyRecipeToType(event, 'immersiveengineering:arc_furnace',   [rid], obj.O);
				!!(F & R.NO_MK) && Capy.copyRecipeToType(event, 'mekanism:smelting', [rid], obj.O);
				break;
			case !!(F & R.ARC):
				Capy.copyRecipeToType(event, 'immersiveengineering:arc_furnace',   [rid], obj.O);
				!!(F & R.NO_MK) && Capy.copyRecipeToType(event, 'mekanism:smelting', [rid], obj.O);
				break;
		}

		if (!!(F & R.COPY)) {
			event.remove({ id: rid });
		}
	}
})