// priority: 100

const Capy = {};

// Add an tag to an item (not block!)
Capy.addTagToItem = (item, tag) => {
	return event => event.add(tag, item);
}

Capy.addTagToBlock = (block, tag) => {
	return event => event.add(tag, block);
}

Capy.removeTagFromBlock = (block, tag) => {
	return event => event.remove(tag, block);
}

Capy.removeRecipeAndHide = (item) => {
	ServerEvents.recipes(event => event.remove({ output: item }));
	ServerEvents.tags('item', event => event.add('c:hidden_from_recipe_viewers', item));
}

Capy.addRestrictionForList = (stage, list) => {
	for (const item of list) {
		AStages.addRestrictionForItem(`astages/items/${ stage }/${ item.replace(":", "/") }`, stage, item)
		.setCanBeStoredInInventory(true)
		.setCanBeStoredInContainers(true)
		.setCanPickedUp(true)
		.associateLootRestriction();
	}
}

Capy.copyRecipeToType = (event, type, list, options) => {
	let typeStr = type.replace(':', "_");

	for (const rid of list) {
		// Get our recipe
		event.forEachRecipe({ id: rid }, recipe => {
			let newID = `${ recipe.getId() }_${ typeStr }_copy`;
			let json  = JSON.parse(recipe.json);
			let out   = null;

			// Depending on the type, we might need to change the json format
			switch (type) {
				case 'minecraft:blasting':
					json.type = 'minecraft:blasting';
					out = json;
					break;
				case 'immersiveengineering:blast_furnace':
					out = getCrudeBlastFurnaceTemplate(json.ingredient, json.cookingtime * 0.90, json.result, options)
					break;
				case 'capylandtweak:adv_blast_furnace':
					out = getAdvBlastFurnaceTemplate(json.ingredient, json.cookingtime * 0.75, json.result, options)
					break;
				case 'immersiveengineering:arc_furnace':
					out = getArcFurnaceTemplate(json.ingredient, json.cookingtime * 0.55, json.result, options)
					break;
				case 'mekanism:smelting':
					if (json.ingredient.length) {
						// console.log(`Copying multiple recipes (Mekanism moment) ${ recipe.getId() } to ${ newID } (${ type })`);
						for (let ing of json.ingredient) {
							let item = recipe.getOriginalRecipeResult();
							let nid  = `${ recipe.getId() }_${ typeStr }_${ item.id.split(':')[1] }_copy`;
							out      = getMKFurnaceTemplate(ing, json.cookingtime * 0.5, json.result, options)
							event.custom(out).id(nid);
						}
						return;
					}

					// Normal behavior
					out = getMKFurnaceTemplate(json.ingredient, json.cookingtime * 0.5, json.result, options)
					break;
				default: break;
			}

			// console.log(`Copying recipe ${ recipe.getId() } to ${ newID } (${ type })`);
			event.custom(out).id(newID);
		})
	}
}

function getCrudeBlastFurnaceTemplate(input, time, output, options) {
	let obj = {
		type:  "immersiveengineering:blast_furnace",
		input: input,
		time: time,
		result: output
	}

	if (options && options.experience) {
		obj.slag = { item: "create:experience_nugget"}
	}

	return obj
}

function getAdvBlastFurnaceTemplate(input, time, output, options) {
	let obj = {
		type:  "capylandtweak:adv_blast_furnace",
		input: input,
		time: time,
		result: output
	}

	if (options && options.experience) {
		obj.slag = { item: "create:experience_nugget"}
	}

	return obj;
}

function getArcFurnaceTemplate(input, time, output, options) {
	let obj = {
		type:  "immersiveengineering:arc_furnace",
		additives: [],
		energy: 51200, // Base
		input: input,
		time: time,
		results: [output]
	}

	if (options) {
		if (options.experience) {
			obj.secondaries = [{ output: { item: "create:experience_nugget" }, count: options.count || 1 }]
		}

		if (options.energy) {
			obj.energy = options.energy;
		}

		if (options.time) {
			obj.time = options.time;
		}
	}

	return obj;
}

function getMKFurnaceTemplate(input, time, output, options) {
	let obj = {
		type:  "mekanism:smelting",
		input: input,
		time: time,
		output: output
	}

	return obj
}