/*
 * Decompiled with CFR 0.152.
 */
package dev.dimentio.tlm_plus;

import dev.dimentio.tlm_plus.ChestConfigCache;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="tlmplus")
public final class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec.ConfigValue<List<? extends String>> VALID_CHEST_BLOCKS;
    static final ModConfigSpec SPEC;

    private static boolean isValidResourceLocation(Object o) {
        if (!(o instanceof String)) {
            return false;
        }
        String s = (String)o;
        return ResourceLocation.tryParse((String)s) != null;
    }

    @SubscribeEvent
    private static void onConfigLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == SPEC) {
            ChestConfigCache.rebuild();
        }
    }

    @SubscribeEvent
    private static void onConfigReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == SPEC) {
            ChestConfigCache.rebuild();
        }
    }

    static {
        BUILDER.push("chests");
        List<String> defaultChests = List.of("minecraft:chest", "minecraft:barrel");
        VALID_CHEST_BLOCKS = BUILDER.comment(new String[]{"List of block IDs that should be treated as chests.", "These should be block registry names (e.g. minecraft:chest)."}).defineListAllowEmpty("chestBlocks", defaultChests, () -> "", Config::isValidResourceLocation);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

