/*
 * Decompiled with CFR 0.152.
 */
package dev.dimentio.tlm_plus;

import com.mojang.logging.LogUtils;
import dev.dimentio.tlm_plus.Config;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public final class ChestConfigCache {
    private static Set<ResourceLocation> VALID_CHEST_BLOCKS = Collections.emptySet();
    private static final Logger LOGGER = LogUtils.getLogger();

    private ChestConfigCache() {
    }

    public static Set<ResourceLocation> validChests() {
        return VALID_CHEST_BLOCKS;
    }

    static void rebuild() {
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        for (String s : (List)Config.VALID_CHEST_BLOCKS.get()) {
            ResourceLocation id = ResourceLocation.tryParse((String)s);
            if (id == null) {
                LOGGER.warn("[TLMPlus] Invalid block id in chestBlocks config: {}", (Object)s);
                continue;
            }
            set.add(id);
        }
        VALID_CHEST_BLOCKS = Collections.unmodifiableSet(set);
        LOGGER.info("[TLMPlus] Loaded {} valid chest blocks", (Object)VALID_CHEST_BLOCKS.size());
    }
}

