/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.details;

import dan200.computercraft.api.detail.BlockReference;
import dan200.computercraft.shared.details.DetailHelpers;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockDetails {
    public static void fillBasic(Map<? super String, Object> data, BlockReference block) {
        BlockState state = block.state();
        data.put("name", DetailHelpers.getId(BuiltInRegistries.BLOCK, state.getBlock()));
        HashMap<String, Object> stateTable = new HashMap<String, Object>();
        for (Map.Entry entry : state.getValues().entrySet()) {
            Property property = (Property)entry.getKey();
            stateTable.put(property.getName(), BlockDetails.getPropertyValue(property, (Comparable)entry.getValue()));
        }
        data.put("state", stateTable);
    }

    public static void fill(Map<? super String, Object> data, BlockReference block) {
        data.put("tags", DetailHelpers.getTags(block.state().getTags()));
        DetailHelpers.fillMapColour(data, (BlockGetter)block.level(), block.pos(), block.state());
    }

    private static Object getPropertyValue(Property property, Comparable value) {
        if (value instanceof String || value instanceof Number || value instanceof Boolean) {
            return value;
        }
        return property.getName(value);
    }
}

