/*
 * Decompiled with CFR 0.152.
 */
package dev.dimentio.capylandtweak.jei;

import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.client.gui.BlastFurnaceScreen;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIRecipeTypes;
import dev.dimentio.capylandtweak.jei.AdvBlastFurnaceRecipeCategory;
import dev.dimentio.capylandtweak.jei.JEIRecipeExtendedTypes;
import dev.dimentio.capylandtweak.recipe.AdvBlastFurnaceRecipe;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class CapylandJeiPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"jei", (String)"capylandtweak");
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        IGuiHelper guiHelper = reg.getJeiHelpers().getGuiHelper();
        reg.addRecipeCategories(new IRecipeCategory[]{new AdvBlastFurnaceRecipeCategory(guiHelper)});
    }

    private <T extends Recipe<?>> List<RecipeHolder<T>> getRecipes(CachedRecipeList<T> cachedList) {
        return this.getFiltered(cachedList, $ -> true);
    }

    private <T extends Recipe<?>> List<RecipeHolder<T>> getFiltered(CachedRecipeList<T> cachedList, Predicate<T> include) {
        return this.getFilteredAndSorted(cachedList, include, null);
    }

    private <T extends Recipe<?>> List<RecipeHolder<T>> getFilteredAndSorted(CachedRecipeList<T> cachedList, Predicate<T> include, @Nullable Comparator<RecipeHolder<T>> sorting) {
        Stream<RecipeHolder> ret = cachedList.getRecipes((Level)Minecraft.getInstance().level).stream().filter(h -> include.test(h.value()));
        if (sorting != null) {
            ret = ret.sorted(sorting);
        }
        return ret.toList();
    }

    public void registerRecipes(@NotNull IRecipeRegistration reg) {
        reg.addRecipes(JEIRecipeExtendedTypes.ADV_BLAST_FURNACE, this.getRecipes(AdvBlastFurnaceRecipe.RECIPES));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst(IEMultiblockLogic.ADV_BLAST_FURNACE.iconStack(), new RecipeType[]{JEIRecipeExtendedTypes.ADV_BLAST_FURNACE, JEIRecipeTypes.BLAST_FUEL});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration reg) {
        reg.addRecipeClickArea(BlastFurnaceScreen.class, 76, 35, 22, 15, new RecipeType[]{JEIRecipeExtendedTypes.ADV_BLAST_FURNACE, JEIRecipeTypes.BLAST_FUEL});
    }
}

