/*
 * Decompiled with CFR 0.152.
 */
package dev.dimentio.capylandtweak.jei;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.jei.IERecipeCategory;
import dev.dimentio.capylandtweak.jei.JEIRecipeExtendedTypes;
import dev.dimentio.capylandtweak.recipe.AdvBlastFurnaceRecipe;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class AdvBlastFurnaceRecipeCategory
extends IERecipeCategory<AdvBlastFurnaceRecipe> {
    private final IDrawableAnimated flame;
    private final IDrawableAnimated arrow;

    public AdvBlastFurnaceRecipeCategory(IGuiHelper helper) {
        super(helper, JEIRecipeExtendedTypes.ADV_BLAST_FURNACE, "gui.immersiveengineering.advblastFurnace");
        ResourceLocation background = IEApi.ieLoc((String)"textures/gui/blast_furnace.png");
        this.setBackground(helper.createDrawable(background, 42, 9, 100, 64));
        this.setIcon(helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)IEMultiblockLogic.ADV_BLAST_FURNACE.iconStack()));
        this.flame = helper.drawableBuilder(background, 177, 0, 14, 14).buildAnimated(300, IDrawableAnimated.StartDirection.TOP, true);
        this.arrow = helper.drawableBuilder(background, 176, 14, 24, 17).buildAnimated(300, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AdvBlastFurnaceRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 8).addItemStacks(Arrays.asList(recipe.input.getMatchingStacks()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 70, 8).addItemStack(recipe.output.get());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 70, 44).addItemStack(recipe.slag.get());
    }

    public void draw(AdvBlastFurnaceRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics graphics, double mouseX, double mouseY) {
        this.flame.draw(graphics, 12, 27);
        this.arrow.draw(graphics, 33, 26);
        String burnTime = I18n.get((String)"desc.immersiveengineering.info.seconds", (Object[])new Object[]{Utils.formatDouble((double)((float)recipe.time / 20.0f), (String)"#.##")});
        graphics.drawString(ClientUtils.font(), burnTime, 68 - ClientUtils.font().width(burnTime), 48, 0x777777, false);
    }
}

