/*
 * Decompiled with CFR 0.152.
 */
package dev.dimentio.capylandtweak.items.Armors;

import dev.dimentio.capylandtweak.items.Armors.ArmorStats;
import dev.dimentio.capylandtweak.items.Armors.ArmorTier;
import dev.dimentio.capylandtweak.items.Armors.ArmorTiers;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="capylandtweak")
public final class ArmorStatsApplier {
    private static final ResourceLocation COLD_ID = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"cold_resistance");
    private static final ResourceLocation HEAT_ID = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"heat_resistance");
    private static final ResourceLocation THERMAL_ID = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"thermal_resistance");
    private static Holder.Reference<Attribute> COLD_ATTR;
    private static Holder.Reference<Attribute> HEAT_ATTR;
    private static Holder.Reference<Attribute> THERMAL_ATTR;
    private static AttribSpec[] ATTRIB_LIST;
    private static final Map<Item, ArmorStats> ITEM_STATS;

    private static void buildIndex() {
        for (ArmorTier set : ArmorTiers.ALL) {
            for (Map.Entry<Item, ArmorStats> entry : set.items().entrySet()) {
                Item item = entry.getKey();
                ArmorStats stats = entry.getValue();
                if (ITEM_STATS.containsKey(item)) {
                    throw new IllegalStateException("Duplicate item stats for item " + String.valueOf(entry.getKey()));
                }
                ITEM_STATS.put(item, stats);
            }
        }
    }

    @SubscribeEvent
    public static void onItemAttributes(@NotNull ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        ArmorStats stats = ITEM_STATS.get(stack.getItem());
        if (stats == null) {
            return;
        }
        ArmorItem armor = (ArmorItem)stack.getItem();
        ArmorItem.Type type = armor.getType();
        ResourceLocation location = ResourceLocation.withDefaultNamespace((String)("armor." + type.getName()));
        EquipmentSlotGroup slot = EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot());
        if (stats.useThermal()) {
            event.removeAllModifiersFor(COLD_ATTR);
            event.removeAllModifiersFor(HEAT_ATTR);
        }
        for (AttribSpec spec : ATTRIB_LIST) {
            Holder<Attribute> attribute = spec.attrib();
            if (attribute == null || stats.useThermal() && (attribute == HEAT_ATTR || attribute == COLD_ATTR)) continue;
            double value = spec.value().applyAsDouble(stats);
            AttributeModifier modifier = new AttributeModifier(location, value, AttributeModifier.Operation.ADD_VALUE);
            event.removeAllModifiersFor(attribute);
            event.addModifier(attribute, modifier, slot);
        }
    }

    @SubscribeEvent
    public static void onModifyComponents(@NotNull ModifyDefaultComponentsEvent event) {
        for (Map.Entry<Item, ArmorStats> entry : ITEM_STATS.entrySet()) {
            Item item = entry.getKey();
            ArmorStats stats = entry.getValue();
            event.modify((ItemLike)item, patch -> patch.set(DataComponents.MAX_DAMAGE, (Object)stats.durability()));
        }
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            COLD_ATTR = BuiltInRegistries.ATTRIBUTE.getHolder(COLD_ID).orElse(null);
            HEAT_ATTR = BuiltInRegistries.ATTRIBUTE.getHolder(HEAT_ID).orElse(null);
            THERMAL_ATTR = BuiltInRegistries.ATTRIBUTE.getHolder(THERMAL_ID).orElse(null);
            ATTRIB_LIST = new AttribSpec[]{new AttribSpec((Holder<Attribute>)Attributes.ARMOR, ArmorStats::armor), new AttribSpec((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, ArmorStats::toughness), new AttribSpec((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, ArmorStats::knockback), new AttribSpec((Holder<Attribute>)THERMAL_ATTR, ArmorStats::thermalRes), new AttribSpec((Holder<Attribute>)COLD_ATTR, ArmorStats::coldRes), new AttribSpec((Holder<Attribute>)HEAT_ATTR, ArmorStats::heatRes)};
            ArmorStatsApplier.buildIndex();
        });
    }

    static {
        ATTRIB_LIST = new AttribSpec[0];
        ITEM_STATS = new IdentityHashMap<Item, ArmorStats>();
    }

    private record AttribSpec(Holder<Attribute> attrib, ToDoubleFunction<ArmorStats> value) {
    }
}

