/*
 * Decompiled with CFR 0.152.
 */
package dev.dimentio.capylandtweak.datagen;

import dev.dimentio.capylandtweak.datagen.ModBlockLoot;
import dev.dimentio.capylandtweak.datagen.ModBlockState;
import dev.dimentio.capylandtweak.datagen.ModBlockTags;
import dev.dimentio.capylandtweak.datagen.ModItemModel;
import dev.dimentio.capylandtweak.datagen.ModItemTags;
import dev.dimentio.capylandtweak.datagen.ModLang;
import dev.dimentio.capylandtweak.datagen.ModRecipe;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="capylandtweak")
public class ModDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture lookup = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        ModBlockTags blockTags = (ModBlockTags)gen.addProvider(event.includeServer(), (DataProvider)new ModBlockTags(output, lookup, helper));
        List<LootTableProvider.SubProviderEntry> subProvider = List.of(new LootTableProvider.SubProviderEntry(ModBlockLoot::new, LootContextParamSets.BLOCK));
        LootTableProvider lootProvider = new LootTableProvider(output, Set.of(), subProvider, lookup);
        gen.addProvider(event.includeServer(), (DataProvider)new ModItemTags(output, lookup, blockTags.contentsGetter(), helper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModRecipe(output, lookup));
        gen.addProvider(event.includeClient(), (DataProvider)new ModBlockState(output, helper));
        gen.addProvider(event.includeServer(), (DataProvider)lootProvider);
        gen.addProvider(event.includeClient(), (DataProvider)new ModItemModel(output, helper));
        gen.addProvider(event.includeClient(), (DataProvider)new ModLang(output));
    }
}

